function doTable(EST1,EST2,ti,FS)
N = length(EST1.b);

s1(1,:) = (EST1.CI90(1,:)>0)|(EST1.CI90(2,:)<0);
s1(2,:) = (EST1.CI95(1,:)>0)|(EST1.CI95(2,:)<0);
s1(3,:) = (EST1.CI99(1,:)>0)|(EST1.CI99(2,:)<0); 
s1 = sum(s1,1);

s2(1,:) = (EST2.CI90(1,:)>0)|(EST2.CI90(2,:)<0);
s2(2,:) = (EST2.CI95(1,:)>0)|(EST2.CI95(2,:)<0);
s2(3,:) = (EST2.CI99(1,:)>0)|(EST2.CI99(2,:)<0); 
s2 = sum(s2,1);


fon = '\tiny' ;
st  = '\ast';

fprintf('%s\n \n',ti)
fprintf('Same year') 

for j = 1:N
    if s1(1,j)==0
    fprintf('& $ %6.2f $ ',EST1.b(j))
    elseif s1(1,j)==1
        fprintf('& $ %6.2f^{%s} $ ',EST1.b(j),st)
        elseif s1(1,j)==2
        fprintf('& $ %6.2f^{%s%s} $ ',EST1.b(j),st,st)
        elseif s1(1,j)==3
        fprintf('& $ %6.2f^{%s%s%s} $ ',EST1.b(j),st,st,st)
    end
end
fprintf('\\\\ \n')
for j = 1:N
fprintf('& %s{$ (%6.2f,%6.2f) $}',fon,EST1.CI95(:,j))
end
fprintf('\\\\ \n')


fprintf('Following year') 
for j = 1:N
if s2(1,j)==0
    fprintf('& $ %6.2f $ ',EST2.b(j))
    elseif s2(1,j)==1
        fprintf('& $ %6.2f^{%s} $ ',EST2.b(j),st)
        elseif s2(1,j)==2
        fprintf('& $ %6.2f^{%s%s} $ ',EST2.b(j),st,st)
        elseif s2(1,j)==3
        fprintf('& $ %6.2f^{%s%s%s} $ ',EST2.b(j),st,st,st)
    end
end
fprintf('\\\\ \n')
for j = 1:N
fprintf('& %s{$ (%6.2f,%6.2f) $}',fon,EST2.CI95(:,j))
end
fprintf('\\\\ \n')
if FS==1
    fon = '\scriptsize' ;

 fprintf('1st Stage F ')
 for j = 1:N
fprintf('& %s{$%6.2f $}',fon,EST1.Fstat(j))
 end
fprintf('\\\\ \n')
 fprintf('MSW(2016) Wald')
for j = 1:N
fprintf('& %s{$%6.2f $}',fon,EST1.Fstat_mmo(j))
end
elseif FS == 2 
       fon = '\scriptsize' ;

fprintf('MSW(2016) Wald')
for j = 1:N
fprintf('& %s{$%6.2f $}',fon,EST1.Fstat(j))
end
end
fprintf('\n \n')
